define(['underscore', 'backbone'], function (_, Backbone) {
    'use strict';

    var TimeSlotsByDateModel = Backbone.Model.extend({
        idAttribute: 'date',
        toJSON: function() {
            var jsObject = _.clone(this.attributes);
            if (!_.isUndefined(jsObject.timeSlots)) {
                jsObject.timeSlots = jsObject.timeSlots.toJSON();
            }

            return jsObject;
        },
    });

    // collection
    return Backbone.Collection.extend({
        model: TimeSlotsByDateModel,
        comparator: function(model) {
            return new Date(model.get('date'));
        },
        hasDate: function(date) {
            return !_.isUndefined(this.get(date));
        },
    });
});
